$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    var thisdir = params[1] + '/' + params[2];  //get subfolder (if any) that page is running from and page name
    var framework_id = -1;
    var arrayLength = params.length;
    for (var i = 0; i < arrayLength; i++) {
        if (params[i] == 'f') {
            framework_id = params[i + 1];
        }
    }

    var table_emails = $('#table_emails').DataTable({
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/email/get_messages/f/' + framework_id,
            "data": function (d) {
                d.framework_id = framework_id;
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
                d.selectedround = $('#selectedround option:selected').val();
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "to"},
            {"data": "from"},
            {"data": "subject"},
            {"data": "status"},
            {"data": "details"},
            {"data": "received_at"},
        ],
        "aoColumnDefs": [
            { "bSortable": false, "aTargets": [0] },
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            },
            {
                "aTargets": [5],
                "sWidth": "15%",
            }
        ],
        "fnDrawCallback": function (oSettings) {
            $('#table_emails').DataTable().rows(':not(.parent)').nodes().to$().find('td:first-child').trigger('click');
            $('#table_emails').DataTable().rows(':not(.parent)').nodes().to$().find('td:first-child').trigger('click');
        },
        "buttons": [{
            "extend": 'copy',
            "exportOptions": {
                // "columns": ':not(:last-child)'
            }
        },
            {
                "extend": 'print',
                "exportOptions": {
                    // "columns": ':not(:last-child)'
                }
            },
            {
                "extend": 'excel',
                "exportOptions": {
                    // "columns": ':not(:last-child)'
                }
            }],
        "lengthMenu": [[15, 25, 50, 100, -1], [15, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        },
        "initComplete": function (settings, json) {
            table_emails.buttons().container().insertBefore('#table_emails_info');
            table_emails.buttons().container().css("float", "right");
        }
    });

    table_emails.order( [ 6, 'desc' ] )
    .draw();
    // t2 = setInterval(function () {
    //     $('#table_emails').DataTable().ajax.reload(null, false);
    // }, 120000);


    function load_stats() {
        show_loading_message();
        var request = $.ajax({
            url: '/' + subdir + '/email/get_stats/f/' + framework_id,
            cache: false,
            data: 'selectedround='+$('#selectedround option:selected').val(),
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('#sent').html(output.data['sent']);
                $('#bounces').html(output.data['bounced']);
                $('#opens').html(output.data['opens']);

            } else {
                alert("error");
            }
            hide_loading_message();
        });
    }

    load_stats();
    /*
     * ERROR HANDLING
     */

    $.fn.dataTable.ext.errMode = 'none';

    //manually fade out alert (from bulk import)
    setTimeout(function () {
        $('.alert').fadeOut('slow');
    }, 3000);

// Hide message
    function hide_message() {
        $('#message').html('').attr('class', '');
        $('#message_container').hide();
    }

// Show loading message
    function show_loading_message() {
        $('#loading_container').show();
    }

// Hide loading message
    function hide_loading_message() {
        $('#loading_container').hide();
    }

// Show lightbox
    function show_lightbox() {
        if (window.innerWidth < 768) {
            var yloc = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset);
            yloc = yloc - 40;
            $('.lightbox_container').css('top', yloc + 'px');
        }
        $('.lightbox_container').show();
        $('.lightbox_bg').show();
        $('.lightbox_container').show();
        $('.lightbox_container').scrollTop(0);
    }

// Hide lightbox
    function hide_lightbox() {
        $('.lightbox_bg').hide();
        $('.lightbox_container').hide();
    }

// Lightbox background
    $(document).on('click', '.lightbox_bg', function () {
        hide_lightbox();
    });
// Lightbox close button
    $(document).on('click', '.lightbox_close', function () {
        hide_lightbox();
    });
// Escape keyboard key
    $(document).keyup(function (e) {
        if (e.keyCode == 27) {
            hide_lightbox();
        }
    });

// Hide iPad keyboard
    function hide_ipad_keyboard() {
        document.activeElement.blur();
        $('input').blur();
    }

    $('#selectedround').change(function () {
        $('#table_emails').DataTable().ajax.reload(null, true);
        load_stats();
    });

});
