$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    var thisdir = params[1] + '/' + params[2];
    var framework_id = -1;
    var arrayLength = params.length;
    for (var i = 0; i < arrayLength; i++) {
        if (params[i] == 'f'){
            framework_id = params[i + 1];
        }
    }

    // On page load: datatable
    var table_frameworks = $('#table_frameworks').DataTable({
        //"ajax": "./includes/frameworkdata.php?job=get_frameworks",
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/framework/get_framework_mails/f/' + framework_id,
            "data": function (d) {
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "framework_name"},
            {"data": "framework_type"},
            {"data": "is_custom_mail"},
            {"data": "is_debug"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        }
    });


    /*
     * ERROR HANDLING
     */

    $.fn.dataTable.ext.errMode = 'none';

    $('#table_frameworks')
        .on('error.dt', function (e, settings, techNote, message) {
            console.log('An error has been reported by DataTables: ', message);
        })
        .DataTable();


// On page load: form validation
    jQuery.validator.setDefaults({
        success: 'valid',
        rules: {
            mail_password: {
                minlength: 3
            },
            confirm_mail_password: {
                minlength: 3,
                equalTo: "#mail_password"
            }
        },
        errorPlacement: function (error, element) {
            error.insertBefore(element);
        },
        highlight: function (element) {
            $(element).parent('.field_container').removeClass('valid').addClass('error');
        },
        unhighlight: function (element) {
            $(element).parent('.field_container').addClass('valid').removeClass('error');
        }
    });
    var form_framework = $('#form_framework');
    form_framework.validate();

// Hide message
    function hide_message() {
        $('#message').html('').attr('class', '');
        $('#message_container').hide();
    }

// Show loading message
    function show_loading_message() {
        $('#loading_container').show();
    }

// Hide loading message
    function hide_loading_message() {
        $('#loading_container').hide();
    }

// Show lightbox
    function show_lightbox() {
        if (window.innerWidth < 768){
            var yloc = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset) ;
            yloc = yloc - 40;
            $('.lightbox_container').css('top',yloc+'px');
        }
        $('.lightbox_container').show();
        $('.lightbox_bg').show();
        $('.lightbox_container').show();
        $('.lightbox_container').scrollTop(0);
    }

// Hide lightbox
    function hide_lightbox() {
        $('.lightbox_bg').hide();
        $('.lightbox_container').hide();
    }

// Lightbox background
    $(document).on('click', '.lightbox_bg', function () {
        hide_lightbox();
    });
// Lightbox close button
    $(document).on('click', '.lightbox_close', function () {
        hide_lightbox();
    });
// Escape keyboard key
    $(document).keyup(function (e) {
        if (e.keyCode == 27) {
            hide_lightbox();
        }
    });

// Hide iPad keyboard
    function hide_ipad_keyboard() {
        document.activeElement.blur();
        $('input').blur();
    }


// Edit framework button
    $(document).on('click', '.function_edit a', function (e) {
        e.preventDefault();
        // Get company information from database
        //show_loading_message();
        var id = $(this).data('id');
        var request = $.ajax({
            url: '/' + subdir + '/framework/get_framework_mail/f/' + framework_id,
            cache: false,
            data: 'id=' + id,
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                // var framework_id = output.data[0].id;
                $('.lightbox_content h2').text('Edit Framework');
                $('#form_framework button').html('Edit Framework <i class="icon-arrow-right14 position-right"></i>');
                $('#form_framework').attr('class', 'form edit');
                $('#form_framework').attr('data-id', id);
                $('#form_framework').attr('data-name', output.data[0].framework_name);
                $('#form_framework .field_container label.error').hide();
                $('#form_framework .field_container').removeClass('valid').removeClass('error');
                $('#form_framework #framework_name').val(output.data[0].framework_name);
                $('#form_framework #framework_type').val(output.data[0].framework_type);
                $('#form_framework #user_logo').val(output.data[0].user_logo);
                $('#form_framework #mail_host').val(output.data[0].mail_host);
                $('#form_framework #mail_port').val(output.data[0].mail_port);
                $('#form_framework #mail_username').val(output.data[0].mail_username);
                $('#form_framework #debug_email').val(output.data[0].debug_email);
                $('#form_framework #mail_password').val('');
                $('#form_framework #confirm_mail_password').val('');

                $('#form_framework #is_custom_mail').empty();
                $.each(output.data[0].custom_mail_statuses, function (key, val) {
                    var isSelected = false;
                    if (key == output.data[0].is_custom_mail) {
                        isSelected = true;
                    }
                    $('#form_framework #is_custom_mail').append($('<option>', {
                        value: key,
                        text: val,
                        selected: isSelected
                    }));
                });
                $('#form_framework #mail_background_send').empty();
                $.each(output.data[0].mail_background_statuses, function (key, val) {
                    var isSelected = false;
                    if (key == output.data[0].mail_background_send) {
                        isSelected = true;
                    }
                    $('#form_framework #mail_background_send').append($('<option>', {
                        value: key,
                        text: val,
                        selected: isSelected
                    }));
                });
                $('#form_framework #is_debug').empty();
                $.each(output.data[0].debug_statuses, function (key, val) {
                    var isSelected = false;
                    if (key == output.data[0].is_debug) {
                        isSelected = true;
                    }
                    $('#form_framework #is_debug').append($('<option>', {
                        value: key,
                        text: val,
                        selected: isSelected
                    }));
                });
                $('#form_framework #mail_ssl').empty();
                $.each(output.data[0].ssl_statuses, function (key, val) {
                    var isSelected = false;
                    if (key == output.data[0].mail_ssl) {
                        isSelected = true;
                    }
                    $('#form_framework #mail_ssl').append($('<option>', {
                        value: key,
                        text: val,
                        selected: isSelected
                    }));
                });
                if (output.data[0].is_custom_mail == 0) {
                    $('#mail_settings').hide();
                } else {
                    $('#mail_settings').show();
                }
                if (output.data[0].is_debug == 0) {
                    $('#debug_settings').hide();
                } else {
                    $('#debug_settings').show();
                }

                hide_loading_message();
                show_lightbox();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'error');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'error');
        });
    });

// Edit company submit form
    $(document).on('submit', '#form_framework.edit', function (e) {
        e.preventDefault();
        // Validate form
        if (form_framework.valid() == true) {
            // Send company information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var id = $('#form_framework').attr('data-id');
            var form_data = $('#form_framework').serialize();
            var request = $.ajax({
                url: '/' + subdir + '/framework/edit_framework_mail/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'id': id}) + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    $('#table_frameworks').DataTable().ajax.reload(function () {
                        hide_loading_message();
                        show_message("Framework edited successfully.", 'success');
                    }, true);
                } else if (output['result'] == 'taken') {
                    $('#form_framework #uname').val('');
                    //$('#form_framework #uname-error').removeClass('valid');  $('.nav').find('a.current').parent()
                    hide_loading_message();
                    show_lightbox();
                    alert(output['message']);

                } else {
                    hide_loading_message();
                    show_message('Edit request failed: ' + output['message'], 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Edit request failed: ' + textStatus, 'error');
            });
        }
    });


//tooltips for tables
    $('[data-toggle="tooltip"]').tooltip({});

    $('#drop').change(function () {
        $('#table_frameworks').DataTable().ajax.reload(null, true);
    });

    $('#activetype').change(function () {
        $('#table_frameworks').DataTable().ajax.reload(null, true);
    });

    $('#is_custom_mail').change(function () {
        if ($('#is_custom_mail').val() == 0) {
            $('#mail_settings').hide();
        } else {
            $('#mail_settings').show();
        }
    });

    $('#is_debug').change(function () {
        if ($('#is_debug').val() == 0) {
            $('#debug_settings').hide();
        } else {
            $('#debug_settings').show();
        }
    });

    $('#activeonlyno').click(function () {
        $('#table_frameworks').DataTable().ajax.reload(null, true);
    });
    $('#activeonlyyes').click(function () {
        $('#table_frameworks').DataTable().ajax.reload(null, true);
    });

//hide search option for yes/no drop downs
    $('#showcancelled').select2({
        minimumResultsForSearch: -1
    });
    $('#activetype').select2({
        minimumResultsForSearch: -1
    });


});
