$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    var dir = params[1] + '/' + params[2];  //get subfolder (if any) that page is running from and page name
    var framework_id = -1;
    var arrayLength = params.length;
    for (var i = 0; i < arrayLength; i++) {
        if (params[i] == 'f'){
            framework_id = params[i + 1];
        }
    }

    // On page load: datatable
    var table_admins = $('#table_admins').DataTable({
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/admin/get_admins/f/' + framework_id,
            "data": function (d) {
                d.selectedframework = $('#drop option:selected').val();
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "uname"},
            {"data": "fname"},
            {"data": "lname"},
            {"data": "frameworks"},
            {"data": "superadmin"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        }
    });


    /*
     * ERROR HANDLING
     */

    $.fn.dataTable.ext.errMode = 'none';

    $('#table_admins')
        .on('error.dt', function (e, settings, techNote, message) {
            console.log('An error has been reported by DataTables: ', message);
        })
        .DataTable();


    $.validator.addMethod("checkUserName",
        function (value, element) {
            var result = false;
            $.ajax({
                type: "POST",
                url: '/' + subdir + '/admin/check_admin_name/f/' + framework_id,
                data: {uname: value},
                success: function (data) {
                    result = (data == true) ? true : false;
                }
            });
            // return true if username is exist in database
            return result;
        },
        "This username is already taken! Try another."
    );

// On page load: form validation
    jQuery.validator.setDefaults({
        success: 'valid',
        rules: {
            uname: {
                required: true,
            },
            password: {
                is_pw_strong: {
                    depends: isPasswordRequired,
                    param: true
                }
            },
            confirm_password: {
                equalTo: "#password"
            },
            mobile: {
                required:  function() {
                    if ($('#mfa_sms').val() == 1 && $('#use_mfa').val() == 1) {
                        return true;
                    }
                    else {
                        return false;
                    }
                }
            },
            email: {
                required:  function() {
                    if (($('#mfa_sms').val() == 0 && $('#use_mfa').val() == 1)) {
                        return true;
                    }
                    else {
                        return false;
                    }
                }
            }
        },
        errorPlacement: function (error, element) {
            error.insertBefore(element);
        },
        highlight: function (element) {
            $(element).parent('.field_container').removeClass('valid').addClass('error');
        },
        unhighlight: function (element) {
            $(element).parent('.field_container').addClass('valid').removeClass('error');
        }
    });

    $("#password").complexify({
            minimumChars: $('#pwl').val(),
            banMode: 'strict',
            strengthScaleFactor: $('#pwf').val(),
            bannedPasswords: custom_arr()
        },
        function (valid, complexity) {
            // Show percentage
            var outputstr = "";
            var cp = Math.round(complexity);
            if (cp < $('#pws').val()) {
                var strength = '<span style="color:darkorange"><strong>Strength: ' + cp + '</strong></span>';
            } else {
                var strength = '<span style="color:green"><strong>Strength: ' + cp + '</strong></span>';
            }
            var length = $("#password").val().length;
            if (length < $('#pwl').val()) {
                var lenstr = '<span style="color:darkorange"><strong>Length: ' + length + '</strong></span>';
            } else {
                var lenstr = '<span style="color:green"><strong>Length: ' + length + '</strong></span>';
            }
            outputstr = strength + '; ' + lenstr;
            $('#pw_strength').html(outputstr);
        }
    );
    function custom_arr(){
        if ($('#pwacw').val() == 1){
            var arr = [];
        } else {
            var arr = window.COMPLEXIFY_BANLIST;
        }
        return arr;
    }

    $.validator.addMethod("is_pw_strong", function (value) {
        var score;
        $("#password").complexify({
                minimumChars: $('#pwl').val(),
                banMode: 'strict',
                strengthScaleFactor: $('#pwf').val(),
                bannedPasswords: custom_arr()
            },
            function (valid, complexity) { //show de password level
                // Show percentage
                score = complexity;
            }
        );
        if (score < $('#pws').val() || $("#password").val().length < $('#pwl').val()) {
            return false;
        } else {
            return true;
        }
    }, function (params, element) {
        return 'Choose a strong password of at least '+$('#pwl').val()+' characters, containing no common words and a mix of letters, numbers and symbols'; // checkmsg;
    });

    $.validator.addMethod("pwcheck", function(value) {
        return /[A-Z]/.test(value) // consists of only these
            && /[a-z]/.test(value) // has a lowercase letter
            && /\d/.test(value) // has a digit
    }, function(params, element) {
        return 'Please include at least one uppercase, lowercase, and number.'
    });

    function isPasswordRequired() {
        var check = true;
        //if form is edit AND password blank then is not required, otherwise (if form is add, OR form is edit and length > 0) it is required
        if ($( "#form_admin" ).hasClass( "edit" ) && $('#password').val().length == 0) check = false;
        return check;
    }

    var form_admin = $('#form_admin');
    form_admin.validate();

// Hide message
    function hide_message() {
        $('#message').html('').attr('class', '');
        $('#message_container').hide();
    }

// Show loading message
    function show_loading_message() {
        $('#loading_container').show();
    }

// Hide loading message
    function hide_loading_message() {
        $('#loading_container').hide();
    }

// Show lightbox
    function show_lightbox() {
        if (window.innerWidth < 768){
            var yloc = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset) ;
            yloc = yloc - 40;
            $('.lightbox_container').css('top',yloc+'px');
        }
        $('.lightbox_container').show();
        $('.lightbox_bg').show();
        $('.lightbox_container').show();
        $('.lightbox_container').scrollTop(0);
    }

// Hide lightbox
    function hide_lightbox() {
        $('.lightbox_bg').hide();
        $('.lightbox_container').hide();
    }

// Lightbox background
    $(document).on('click', '.lightbox_bg', function () {
        hide_lightbox();
    });
// Lightbox close button
    $(document).on('click', '.lightbox_close', function () {
        hide_lightbox();
    });
// Escape keyboard key
    $(document).keyup(function (e) {
        if (e.keyCode == 27) {
            hide_lightbox();
        }
    });

// Hide iPad keyboard
    function hide_ipad_keyboard() {
        document.activeElement.blur();
        $('input').blur();
    }

// Add admin button
    $(document).on('click', '#add_admin', function (e) {
        e.preventDefault();
        var request = $.ajax({
            url: '/' + subdir + '/admin/get_frameworks/f/' + framework_id,
            cache: false,
            data: 'id=1',
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('.lightbox_content h2').text('Add Administrator');
                $('#form_admin button').html('Add Administrator <i class="icon-arrow-right14 position-right"></i>');
                $('#form_admin').attr('class', 'form add');
                $('#form_admin .field_container label.error').hide();
                $('#form_admin .field_container').removeClass('valid').removeClass('error');
                $('#form_admin #uname').val('');
                $('#form_admin #fname').val('');
                $('#form_admin #lname').val('');
                $('#form_admin #email').val('');
                $('#form_admin #password').val('');
                $('#form_admin #confirm_password').val('');
                $('#form_admin #pw_strength').html('');
                $('#form_admin #password').attr('required', true);
                $('#form_admin #confirm_password').attr('required', true);
                $('#lblconfpwd').html('Confirm Password: <span class="required">*</span>');
                $('#lblpwd').html('Password: <span class="required">*</span>');
                $('#form_admin #superadmin').val(0);
                $('#form_admin #frameworks').empty();
                $('#form_admin #use_mfa').val(0);
                $('#form_admin #mfa_sms').val(0);
                $('#form_admin #mobile').val('');
                $('#form_admin #email').val('');
                $('.field_container').removeClass('valid');
                // $.each(output.data[0].frameworks, function(key, val){
                //   $('#form_admin #frameworks').append('<div class="checkbox"><label style="margin-left: 10px; line-height: 40px;"><input type="checkbox" style="width: auto;" name="frameworkid[]" value="'+val['id']+'">'+val['name']+'</label></div>');
                // });

                var list = "";
                $.each(output.data.frameworks, function (key, val) {
                    list = list + '<label class="container">' + val['name'];
                    list = list + '<input type="checkbox" checked="checked" name="frameworkid[]" value="' + parseInt(val['id']) + '">';
                    list = list + '<span class="checkmark"></span></label>';
                });
                $('#form_admin #frameworks').append(list);

                hide_loading_message();
                show_lightbox();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'warning');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'warning');
        });
    });

// Add admin submit form
    $(document).on('submit', '#form_admin.add', function (e) {
        e.preventDefault();
        // Validate form
        if (form_admin.valid() == true) {
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var form_data = $('#form_admin').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');
            var myFrameworks = new Array();
            $("input:checked").each(function () {
                myFrameworks.push($(this).val());
            });
            var json_arr = JSON.stringify(myFrameworks);
            var request = $.ajax({
                url: '/' + subdir + '/admin/add_admin/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'myFrameworks': json_arr}) + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    $('#table_admins').DataTable().ajax.reload(function () {
                    }, true);
                    hide_loading_message();
                    show_message("Administrator added successfully.", 'success');
                } else {
                    hide_loading_message();
                    show_message(output.message, 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Add request failed: ' + textStatus, 'danger');
            });
        }
    });

// Edit admin button
    $(document).on('click', '.function_edit a', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        var id = $(this).data('id');
        var request = $.ajax({
            url: '/' + subdir + '/admin/get_admin/f/' + framework_id,
            cache: false,
            data: 'id=' + id,
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                // var framework_id = output.data[0].framework_id;
                $('.lightbox_content h2').text('Edit Administrator');
                $('#form_admin button').html('Edit Administrator <i class="icon-arrow-right14 position-right"></i>');
                $('#form_admin').attr('class', 'form edit');
                $('#form_admin').attr('data-id', id);
                $('#form_admin').attr('data-name', output.data[0].fname + ' ' + output.data[0].lname);
                $('#form_admin .field_container label.error').hide();
                $('#form_admin .field_container').removeClass('valid').removeClass('error');
                $('#form_admin #uname').val(output.data[0].uname);
                $('#form_admin #fname').val(output.data[0].fname);
                $('#form_admin #lname').val(output.data[0].lname);
                $('#form_admin #password').attr('required', false);
                $('#form_admin #confirm_password').attr('required', false);
                $('#form_admin #confirm_password').val('');
                $('#form_admin #password').val('');
                $('#form_admin #pw_strength').html('');
                $('#lblpwd').html('Password: <br />(leave blank to leave unchanged)');
                $('#lblconfpwd').html('Confirm Password: <br />(leave blank to leave unchanged)');
                $('#form_admin #frameworks').empty();
                var list = "";
                $.each(output.data[0].all_frameworks, function (key, val) {
                    list = list + '<label class="container">' + val['name'];
                    if ($.inArray(parseInt(val['id']), output.data[0].frameworkids) !== -1) {
                        list = list + '<input type="checkbox" checked="checked" name="frameworkid[]" value="' + val['id'] + '">';
                    } else {
                        list = list + '<input type="checkbox" name="frameworkid[]" value="' + val['id'] + '">';
                    }
                    list = list + '<span class="checkmark"></span></label>';
                });
                $('#form_admin #frameworks').append(list);

                $('#form_admin #superadmin').empty();
                $.each(output.data[0].adminstatuses, function (key, val) {
                    var isSelected = false;
                    if (key == output.data[0].superadmin) {
                        isSelected = true;
                    }
                    $('#form_admin #superadmin').append($('<option>', {
                        value: key,
                        text: val,
                        selected: isSelected
                    }));
                });

                $('#form_admin #use_mfa').val(output.data[0].use_mfa);

                if (output.data[0].use_mfa == 0){
                    $('#mfa_settings').hide();
                } else $('#mfa_settings').show();

                if (output.data[0].mobile == '' || output.data[0].mobile == null){
                    $('#form_admin #mfa_sms').val(0);
                } else {
                    $('#form_admin #mfa_sms').val(1);
                    $('#sms_settings').show();
                }

                $('#form_admin #mobile').val(output.data[0].mobile);
                $('#form_admin #email').val(output.data[0].email);

                hide_loading_message();
                show_lightbox();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'error');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'error');
        });
    });

    $(document).on('submit', '#form_admin.edit', function (e) {
        e.preventDefault();
        // Validate form
        if (form_admin.valid() == true) {
            if ($('#form_admin').attr('data-currentstatus') == "1" && $('#form_admin #active').val() == 0 && !confirm("Are you sure you want to cancel '" + $('#form_admin').attr('data-name') + "?")) {
                return;
            }
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var id = $('#form_admin').attr('data-id');
            var form_data = $('#form_admin').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');
            var myFrameworks = new Array();
            $("input:checked").each(function () {
                myFrameworks.push($(this).val());
            });
            var json_arr = JSON.stringify(myFrameworks);
            var request = $.ajax({
                url: '/' + subdir + '/admin/edit_admin/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'id': id}) + '&' + $.param({'myFrameworks': json_arr}) + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    $('#table_admins').DataTable().ajax.reload(function () {
                    }, true);
                    hide_loading_message();
                    show_message("Administrator edited successfully.", 'success');
                } else if (output['result'] == 'taken') {
                    $('#form_admin #uname').val('');
                    hide_loading_message();
                    show_lightbox();
                    alert(output['message']);

                } else {
                    hide_loading_message();
                    show_message('Edit request failed: ' + output['message'], 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Edit request failed: ' + textStatus, 'error');
            });
        }
    });

// Delete admin
    $(document).on('click', '.function_cancel a', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        var admin_name = $(this).data('name');
        var id = $(this).data('id');
        var csrf_token = $('meta[name="csrf-token"]').attr('content');

        $.when(confirm_request("Are you sure you want to delete '" + admin_name + "'?")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/admin/delete_admin/f/' + framework_id,
                        cache: false,
                        dataType: 'json',
                        data: {
                            id: id,
                            name: admin_name,
                            csrf_token: csrf_token
                        },
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            $('#table_admins').DataTable().ajax.reload(function () {
                            }, true);
                            show_message("Administrator '" + admin_name + "' deleted successfully.", 'success');
                        } else {
                            show_message('Delete request failed: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Delete request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });

//tooltips for tables
    $('[data-toggle="tooltip"]').tooltip({});

    $('#drop').change(function () {
        $('#table_admins').DataTable().ajax.reload(null, true);
    });

    $('#activetype').change(function () {
        $('#table_admins').DataTable().ajax.reload(null, true);
    });

    $('#showcancelled').change(function () {
        $('#table_admins').DataTable().ajax.reload(null, true);
    });

    $('#activeonlyno').click(function () {
        $('#table_admins').DataTable().ajax.reload(null, true);
    });
    $('#activeonlyyes').click(function () {
        $('#table_admins').DataTable().ajax.reload(null, true);
    });

//hide search option for yes/no drop downs
    $('#showcancelled').select2({
        minimumResultsForSearch: -1
    });
    $('#activetype').select2({
        minimumResultsForSearch: -1
    });


    $('#use_mfa').change(function () {
        if ($('#use_mfa').val() == 0) {
            $('#mfa_settings').hide();
        } else {
            $('#mfa_settings').show();
        }
    });

    if ($('#use_mfa').val()==1){
        $('#mfa_settings').show();
    } else {
        $('#mfa_settings').hide();
    }

    $('#mfa_sms').change(function () {
        if ($('#mfa_sms').val() == 0) {
            $('#sms_settings').hide();
        } else {
            $('#sms_settings').show();
        }
    });

    if ($('#mfa_sms').val() == 0) {
        $('#sms_settings').hide();
    } else {
        $('#sms_settings').show();
    }
});
