$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    var dir = params[1] + '/' + params[2];
    var framework_id = -1;
    var arrayLength = params.length;
    for (var i = 0; i < arrayLength; i++) {
        if (params[i] == 'f'){
            framework_id = params[i + 1];
        }
    }

    // On page load: datatable
    var table_users = $('#table_users').DataTable({
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/user/get_users/f/' + framework_id,
            "data": function (d) {
                d.selectedframework = $('#drop option:selected').val();
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "email"},
            {"data": "fname"},
            {"data": "lname"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        }
    });


    /*
     * ERROR HANDLING
     */

    $.fn.dataTable.ext.errMode = 'none';

    $('#table_users')
        .on('error.dt', function (e, settings, techNote, message) {
            console.log('An error has been reported by DataTables: ', message);
        })
        .DataTable();


// On page load: form validation
    jQuery.validator.setDefaults({
        success: 'valid',
        rules: {
            uname: {
                required: true,
                //checkUserName: true
            },
            password: {
                required: {
                    depends: isPasswordRequired,
                    param: true
                },
                is_pw_strong: {
                    depends: isPasswordRequired,
                    param: true
                }
            },
            confirm_password: {
                equalTo: "#password"
            }
        },
        errorPlacement: function (error, element) {
            error.insertBefore(element);
        },
        highlight: function (element) {
            $(element).parent('.field_container').removeClass('valid').addClass('error');
        },
        unhighlight: function (element) {
            $(element).parent('.field_container').addClass('valid').removeClass('error');
        }
    });
    var form_user = $('#form_user');
    form_user.validate();

    $.validator.addMethod("pwcheck", function(value) {
        return /[A-Z]/.test(value) // has an uppercase letter
            && /[a-z]/.test(value) // has a lowercase letter
            && /\d/.test(value) // has a digit
    }, function(params, element) {
        return 'Please include at least one uppercase, lowercase, and number.'
    });

    $("#password").complexify({
            minimumChars: $('#pwl').val(),
            banMode: 'strict',
            strengthScaleFactor: $('#pwf').val(),
            bannedPasswords: custom_arr()
        },
        function (valid, complexity) {
            // Show percentage
            var outputstr = "";
            var cp = Math.round(complexity);
            if (cp < $('#pws').val()) {
                var strength = '<span style="color:darkorange"><strong>Strength: ' + cp + '</strong></span>';
            } else {
                var strength = '<span style="color:green"><strong>Strength: ' + cp + '</strong></span>';
            }
            var length = $("#password").val().length;
            if (length < $('#pwl').val()) {
                var lenstr = '<span style="color:darkorange"><strong>Length: ' + length + '</strong></span>';
            } else {
                var lenstr = '<span style="color:green"><strong>Length: ' + length + '</strong></span>';
            }
            outputstr = strength + '; ' + lenstr;
            $('#pw_strength').html(outputstr);
        }
    );
    function custom_arr(){
        if ($('#pwacw').val() == 1){
            var arr = [];
        } else {
            var arr = window.COMPLEXIFY_BANLIST;
        }
        return arr;
    }

    $.validator.addMethod("is_pw_strong", function (value) {
        var score;
        $("#password").complexify({
                minimumChars: $('#pwl').val(),
                banMode: 'strict',
                strengthScaleFactor: $('#pwf').val(),
                bannedPasswords: custom_arr()
            },
            function (valid, complexity) { //show de password level
                // Show percentage
                score = complexity;
            }
        );
        if (score < $('#pws').val() || $("#password").val().length < $('#pwl').val()) {
            return false;
        } else {
            return true;
        }
    }, function (params, element) {
        return 'Choose a strong password of at least '+$('#pwl').val()+' characters, containing no common words and a mix of letters, numbers and symbols'; // checkmsg;
    });

    function isPasswordRequired() {
        var check = true;
        //if form is edit AND password blank then is not required, otherwise (if form is add, OR form is edit and length > 0) it is required
        if ($( "#form_user" ).hasClass( "edit" ) && $('#password').val().length == 0) check = false;
        return check;
    }

// Hide message
    function hide_message() {
        $('#message').html('').attr('class', '');
        $('#message_container').hide();
    }

// Show loading message
    function show_loading_message() {
        $('#loading_container').show();
    }

// Hide loading message
    function hide_loading_message() {
        $('#loading_container').hide();
    }

// Show lightbox
    function show_lightbox() {
        if (window.innerWidth < 768){
            var yloc = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset) ;
            yloc = yloc - 40;
            $('.lightbox_container').css('top',yloc+'px');
        }
        $('.lightbox_container').show();
        $('.lightbox_bg').show();
        $('.lightbox_container').show();
        $('.lightbox_container').scrollTop(0);
    }

// Hide lightbox
    function hide_lightbox() {
        $('.lightbox_bg').hide();
        $('.lightbox_container').hide();
    }

// Lightbox background
    $(document).on('click', '.lightbox_bg', function () {
        hide_lightbox();
    });
// Lightbox close button
    $(document).on('click', '.lightbox_close', function () {
        hide_lightbox();
    });
// Escape keyboard key
    $(document).keyup(function (e) {
        if (e.keyCode == 27) {
            hide_lightbox();
        }
    });

// Hide iPad keyboard
    function hide_ipad_keyboard() {
        document.activeElement.blur();
        $('input').blur();
    }


// Edit user button
    $(document).on('click', '.function_edit a', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        var id = $(this).data('id');
        var request = $.ajax({
            url: '/' + subdir + '/user/get_user/f/' + framework_id,
            cache: false,
            data: {id:id},
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('.lightbox_content h2').text('Edit user');
                $('#form_user button').html('Edit user <i class="icon-arrow-right14 position-right"></i>');
                $('#form_user').attr('class', 'form edit');
                $('#form_user').attr('data-id', id);
                $('#form_user').attr('data-name', output.data[0].fname + ' ' + output.data[0].lname);
                $('#form_user .field_container label.error').hide();
                $('#form_user .field_container').removeClass('valid').removeClass('error');
                $('#form_user #email').text(output.data[0].email);
                $('#form_user #fname').val(output.data[0].fname);
                $('#form_user #lname').val(output.data[0].lname);
                $('#form_user #password').attr('required', false);
                $('#form_user #confirm_password').attr('required', false);
                $('#form_user #confirm_password').val('');
                $('#form_user #pw_strength').html('');
                $('#form_user #password').val('');
                $('.field_container').removeClass('valid');
                $('#lblpwd').html('Password: <br />(leave blank to leave unchanged)');
                $('#lblconfpwd').html('Confirm Password: <br />(leave blank to leave unchanged)');

                hide_loading_message();
                show_lightbox();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'error');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'error');
        });
    });

// Edit submit form
    $(document).on('submit', '#form_user.edit', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        // Validate form
        if (form_user.valid() == true) {
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var myReportingGroups = new Array();
            $("input:checked").each(function () {
                myReportingGroups.push($(this).val());
            });
            var json_arr = JSON.stringify(myReportingGroups);
            var id = $('#form_user').attr('data-id');
            var csrf_token = $('meta[name="csrf-token"]').attr('content');
            var form_data = $('#form_user').serialize();
            var request = $.ajax({
                url: '/' + subdir + '/user/edit_user/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'id': id})  + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    $('#table_users').DataTable().ajax.reload(function () {
                        hide_loading_message();
                        show_message("User edited successfully.", 'success');
                    }, true);
                } else if (output['result'] == 'taken') {
                    $('#form_user #uname').val('');
                    //$('#form_user #uname-error').removeClass('valid');  $('.nav').find('a.current').parent()
                    hide_loading_message();
                    show_lightbox();
                    alert(output['message']);

                } else {
                    hide_loading_message();
                    show_message('Edit request failed: ' + output['message'], 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Edit request failed: ' + textStatus, 'error');
            });
        }
    });

    $(document).on('click', '.function_cancel a', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        var user_name = $(this).data('name');
        var id = $(this).data('id');

        $.when(confirm_request("Are you sure you want to delete '" + user_name + "'?")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/user/delete_user/f/' + framework_id,
                        cache: false,
                        dataType: 'json',
                        data: {id:id,csrf_token:$('meta[name="csrf-token"]').attr('content')},
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            $('#table_users').DataTable().ajax.reload(function () {
                                show_message("User '" + user_name + "' deleted successfully.", 'success');
                            }, true);
                        } else {
                            show_message('Delete request failed: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Delete request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });

    // access user
    $(document).on('click', '.function_access a', function (e) {
        $('.ui-tooltip').remove();
        $("#user_email").val($(this).data('email'));
        $("#user_form").submit();
    });


//tooltips for tables
    $('[data-toggle="tooltip"]').tooltip({});

    $('#drop').change(function () {
        $('#table_users').DataTable().ajax.reload(null, true);
    });

    $('#activetype').change(function () {
        $('#table_users').DataTable().ajax.reload(null, true);
    });

    $('#showcancelled').change(function () {
        $('#table_users').DataTable().ajax.reload(null, true);
    });

    $('#activeonlyno').click(function () {
        $('#table_users').DataTable().ajax.reload(null, true);
    });
    $('#activeonlyyes').click(function () {
        $('#table_users').DataTable().ajax.reload(null, true);
    });

//hide search option for yes/no drop downs
    $('#showcancelled').select2({
        minimumResultsForSearch: -1
    });
    $('#activetype').select2({
        minimumResultsForSearch: -1
    });

    $('#table_users_wrapper').css('max-width', '900px');

});
