$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    var dir = params[1] + '/' + params[2];
    var framework_id = -1;
    var arrayLength = params.length;
    for (var i = 0; i < arrayLength; i++) {
        if (params[i] == 'f'){
            framework_id = params[i + 1];
        }
    }

    // On page load: datatable
    var table_participants = "";
    var table_participants_id = "";

    if ($('#table_participants').length) {
        var hasGender = $('#table_participants thead th').filter(function () {
                return this.textContent === 'Gender';
            }).length > 0;
            var hasMobile = $('#table_participants thead th').filter(function () {
                    return this.textContent === 'Mobile';
                }).length > 0;
        var cols = [
            {"data": "id"},
            {"data": "round_id"},
            {"data": "fname"},
            {"data": "lname"},
            {"data": "email"},
            {"data": "round"},
            {"data": "status"},
            {"data": "functions", "sClass": "functions"}
        ];
        if (hasGender) {
            cols = [
                {"data": "id"},
                {"data": "round_id"},
                {"data": "fname"},
                {"data": "lname"},
                {"data": "email"},
                {"data": "participant_gender"},
                {"data": "round"},
                {"data": "status"},
                {"data": "functions", "sClass": "functions"}
            ];
        }
        if (hasMobile) {
            cols = [
                {"data": "id"},
                {"data": "round_id"},
                {"data": "fname"},
                {"data": "lname"},
                {"data": "email"},
                {"data": "mobile"},
                {"data": "round"},
                {"data": "status"},
                {"data": "functions", "sClass": "functions"}
            ];
        }
        table_participants_id = "table_participants";
        table_participants = $('#table_participants').DataTable({
            'ajax': {
                "type": "POST",
                // "url"    : '/' + dir + '/get_participants',
                "url": '/' + subdir + '/participant_round_display/get_participants/f/' + framework_id,
                "data": function (d) {
                    d.openroundsonly = $('#openroundsonly option:selected').val(); // $('#activeonlyyes').is(':checked');
                    d.selectedround = $('#drop option:selected').val();
                    d.showcancelled = $('#showcancelled option:selected').val();
                    d.csrf_token = $('meta[name="csrf-token"]').attr('content');
                }
            },
            "fnDrawCallback": function (oSettings) {
                $('#table_participants').DataTable().rows(':not(.parent)').nodes().to$().find('td:first-child').trigger('click');
            },
            "columns": cols,
            "order": [],
            "aaSorting": [],
            "buttons": [{
                "extend": 'copy',
                "exportOptions": {
                    "columns": ':visible'
                }
            },
                {
                    "extend": 'print',
                    "exportOptions": {
                        "columns": ':visible'
                    }
                },
                {
                    "extend": 'excel',
                    "exportOptions": {
                        "columns": ':visible'
                    }
                }],
            "aoColumnDefs": [
                {"bSortable": false, "aTargets": [-1]},
                {
                    "aTargets": [0, 1],
                    "bVisible": false,
                    "bSearchable": false
                }
            ],
            "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            "oLanguage": {
                "oPaginate": {
                    "sFirst": " ",
                    "sPrevious": " ",
                    "sNext": " ",
                    "sLast": " ",
                },
                "sLengthMenu": "Records per page: _MENU_",
                "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
                "sInfoFiltered": "(filtered from _MAX_ total records)"
            },
            "initComplete": function (settings, json) {
                table_participants.buttons().container().insertBefore('#table_participants_info');
                table_participants.buttons().container().css("float", "right");
            }
        });
    }


    //hide search option for yes/no drop downs
    $('#round').select2({
        minimumResultsForSearch: 5
    });
    $('#active').select2({
        minimumResultsForSearch: 5
    });
    $("#participant_submit").on('blur',function (e) {
        $('#fname').focus();
    });

    /*
     * ERROR HANDLING
     */

    $.fn.dataTable.ext.errMode = 'none';

    $('#table_participants')
        .on('error.dt', function (e, settings, techNote, message) {
            console.log('An error has been reported by DataTables: ', message);
        })
        .DataTable();

    if ($('#table_participants_manager').length) {
        var hasGender = $('#table_participants_manager thead th').filter(function () {
                return this.textContent === 'Gender';
            }).length > 0;
            var hasMobile = $('#table_participants_manager thead th').filter(function () {
                    return this.textContent === 'Mobile';
                }).length > 0;
        var cols = [
            {"data": "id"},
            {"data": "round_id"},
            {"data": "fname"},
            {"data": "lname"},
            {"data": "email"},
            {"data": "mgr_name"},
            {"data": "mgr_email"},
            {"data": "round"},
            {"data": "status"},
            // { "data": "token" },
            {"data": "functions", "sClass": "functions"}
        ];
        if (hasGender) {
            cols = [
                {"data": "id"},
                {"data": "round_id"},
                {"data": "fname"},
                {"data": "lname"},
                {"data": "email"},
                {"data": "participant_gender"},
                {"data": "mgr_name"},
                {"data": "mgr_email"},
                {"data": "round"},
                {"data": "status"},
                // { "data": "token" },
                {"data": "functions", "sClass": "functions"}
            ];
        }
        if (hasMobile) {
            cols = [
                {"data": "id"},
                {"data": "round_id"},
                {"data": "fname"},
                {"data": "lname"},
                {"data": "email"},
                {"data": "mobile"},
                {"data": "mgr_name"},
                {"data": "mgr_email"},
                {"data": "round"},
                {"data": "status"},
                // { "data": "token" },
                {"data": "functions", "sClass": "functions"}
            ];
        }
        table_participants_id = "table_participants_manager";
        table_participants = $('#table_participants_manager').DataTable({
            'ajax': {
                "type": "POST",
                // "url"    : '/' + dir + '/get_participants/', //using the 'folder' method of finding controller...
                "url": '/' + subdir + '/participant_round_display/get_participants/f/' + framework_id,
                "data": function (d) {
                    d.openroundsonly = $('#openroundsonly option:selected').val(); // $('#activeonlyyes').is(':checked');
                    d.selectedround = $('#drop option:selected').val();
                    d.showcancelled = $('#showcancelled option:selected').val();
                    d.csrf_token = $('meta[name="csrf-token"]').attr('content');
                }
            },
            "fnDrawCallback": function (oSettings) {
                $('#table_participants_manager').DataTable().rows(':not(.parent)').nodes().to$().find('td:first-child').trigger('click');
            },
            "columns": cols,
            "order": [],
            "aaSorting": [],
            "buttons": [{
                "extend": 'copy',
                "exportOptions": {
                    "columns": ':visible'
                }
            },
                {
                    "extend": 'print',
                    "exportOptions": {
                        "columns": ':visible'
                    }
                },
                {
                    "extend": 'excel',
                    "exportOptions": {
                        "columns": ':visible'
                    }
                }],
            "aoColumnDefs": [
                {"bSortable": false, "aTargets": [-1]},
                {
                    "aTargets": [0, 1],
                    "bVisible": false,
                    "bSearchable": false
                }
            ],
            "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            "oLanguage": {
                "oPaginate": {
                    "sFirst": " ",
                    "sPrevious": " ",
                    "sNext": " ",
                    "sLast": " ",
                },
                "sLengthMenu": "Records per page: _MENU_",
                "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
                "sInfoFiltered": "(filtered from _MAX_ total records)"
            },
            "initComplete": function (settings, json) {
                table_participants.buttons().container().insertBefore('#table_participants_manager_info');
                table_participants.buttons().container().css("float", "right");
            }
        });
    }


    // On page load: form validation
    jQuery.validator.setDefaults({
        success: 'valid',
        rules: {
            fiscal_year: {
                required: true,
                min: 2000,
                max: 2025
            }
        },
        errorPlacement: function (error, element) {
            error.insertBefore(element);
        },
        highlight: function (element) {
            $(element).parent('.field_container').removeClass('valid').addClass('danger');
        },
        unhighlight: function (element) {
            $(element).parent('.field_container').addClass('valid').removeClass('danger');
        }
    });
    var form_participant = $('#form_participant');
    form_participant.validate();


    function isEmailRequired() {
        var check = true;
        //if form is edit AND password blank then is not required, otherwise (if form is add, OR form is edit and length > 0) it is required
        if ($("#form_participant").hasClass("edit")) check = false;
        return check;
    }


    // Hide message
    function hide_message() {
        $('#message').html('').attr('class', '');
        $('#message_container').hide();
    }

    // Show loading message
    function show_loading_message() {
        $('#loading_container').show();
    }

    // Hide loading message
    function hide_loading_message() {
        $('#loading_container').hide();
    }

    // Show lightbox
    function show_lightbox() {
        if (window.innerWidth < 768){
            var yloc = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset) ;
            yloc = yloc - 40;
            $('.lightbox_container').css('top',yloc+'px');
        }
        $('.lightbox_container').show();
        $('.lightbox_bg').show();
        $('.lightbox_container').show();
    }

    // Hide lightbox
    function hide_lightbox() {
        $('.lightbox_bg').hide();
        $('.lightbox_container').hide();
    }

    // Lightbox background
    $(document).on('click', '.lightbox_bg', function () {
        hide_lightbox();
    });
    // Lightbox close button
    $(document).on('click', '.lightbox_close', function () {
        hide_lightbox();
    });
    // Escape keyboard key
    $(document).keyup(function (e) {
        if (e.keyCode == 27) {
            hide_lightbox();
        }
    });

    // Hide iPad keyboard
    function hide_ipad_keyboard() {
        document.activeElement.blur();
        $('input').blur();
    }

    // Add participant button
    $(document).on('click', '#add_participant', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        var request = $.ajax({
            // url:          '/' + dir + '/get_rounds/',
            url: '/' + subdir + '/participant_round_display/add_participant_info/f/' + framework_id,
            cache: false,
            data: 'id=1',
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('.lightbox_content h2').text('Add Participant');
                $('#form_participant button').html('Add Participant <i class="icon-arrow-right14 position-right"></i>');
                $('#form_participant').attr('class', 'form add');
                $('#form_participant .field_container label.error').hide();
                $('#form_participant .field_container').removeClass('valid').removeClass('danger');
                $('#form_participant #fname').val('');
                $('#form_participant #lname').val('');
                $('#form_participant #email').val('');
                $('#form_participant #mobile').val('');
                $('#form_participant #mgr_fname').val('');
                $('#form_participant #mgr_lname').val('');
                $('#form_participant #mgr_email').val('');
                $('#form_participant #linked_framework').show();
                $('#form_participant #active').val(1);
                $('#form_participant #round').empty();
                var count = 0;
                var dummyEmails = false;
                $.each(output.data[0].rounds, function (key, val) {
                    if (count == 0) {
                        if (val[2] == 1) {
                            dummyEmails = true;
                        }
                    }
                    $('#form_participant #round').append($('<option>', {
                        value: val[0],
                        text: val[1]
                    }));
                    count++;
                });

                $('#form_participant #email').addClass('required');
                $('#email').prop('disabled', false);
                $('#disable_email').prop( "checked", false );

                if (dummyEmails) {
                    //hide email field, make non-mandatory
                    $('#form_participant #email').removeClass('required');
                    $('#form_participant #email_row').hide();
                } else {
                    $('#form_participant #email').addClass('required');
                    $('#form_participant #email_row').show();
                }
                $('#form_participant #linked_participants').empty();
                $('#form_participant #linked_participants').append('<option value = "0" selected="selected">None / New</option>');
                $.each(output.data[0].linked_participants, function (key, val) {
                    $('#form_participant #linked_participants').append($('<option>', {
                        value: val['Pid'],
                        text: val['fname'] + ' ' + val['lname'] + ' (' + val['email'] + ')'
                    }));
                });
                $('#form_participant #reporting_groups').empty();

                // $.each(output.data[0].reporting_groups, function(key, val){
                //   $('#form_participant #reporting_groups').append('<div class="checkbox"><label style="margin-left: 10px; line-height: 40px;"><input type="checkbox" style="width: auto;" name="reportinggroupid[]" value="'+val['id']+'">'+val['name']+'</label></div>');
                // });

                var list = "";
                $.each(output.data[0].reporting_groups, function (key, val) {
                    list = list + '<label class="container">' + val['name'];
                    list = list + '<input type="checkbox" name="reportinggroupid[]" value="' + val['id'] + '">';
                    list = list + '<span class="checkmark"></span></label>';
                });
                $('#form_participant #reporting_groups').append(list);


                $('#form_participant #gender').empty();
                $('#form_participant #gender').append($('<option>', {
                    value: 'M',
                    text: 'Male',
                    selected: true
                }));
                $('#form_participant #gender').append($('<option>', {
                    value: 'F',
                    text: 'Female',
                }));
                $('#form_participant #gender').append($('<option>', {
                    value: 'O',
                    text: 'Other',
                }));

                hide_loading_message();
                show_lightbox();
                $("#form_participant #fname").focus();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'warning');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'warning');
        });
    });

    // Add participant submit form
    $(document).on('submit', '#form_participant.add', function (e) {
        e.preventDefault();
        // Validate form
        if (form_participant.valid() == true) {
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var form_data = $('#form_participant').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');
            var myReportingGroups = new Array();
            $("input:checked").each(function () {
                myReportingGroups.push($(this).val());
            });
            var json_arr = JSON.stringify(myReportingGroups);
            var request = $.ajax({
                url: '/' + subdir + '/participant_round_upload/add_participant/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'myReportingGroups': json_arr}) + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                // contentType:  'application/json; charset=utf-8',
                type: 'post'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    $('#' + table_participants_id + '').DataTable().ajax.reload(function () {
                        hide_loading_message();
                        show_message("Participant added successfully.", 'success');
                    }, true);
                } else {
                    hide_loading_message();
                    show_message(output.message, 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Add request failed: ' + textStatus, 'danger');
            });
        }
    });

    // Edit participant button
    $(document).on('click', '.function_edit a', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        var id = $(this).data('id');
        var participant_round_id = $(this).data('participant_round_id');
        var request = $.ajax({
            // url:          '/' + dir + '/get_participant',
            url: '/' + subdir + '/participant_round_display/get_participant/f/' + framework_id,
            cache: false,
            data: 'id=' + id,
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                var round_id = output.data[0].round_id;
                $('.lightbox_content h2').text('Edit participant');
                $('#form_participant button').html('Edit participant <i class="icon-arrow-right14 position-right"></i>');
                $('#form_participant').attr('class', 'form edit');
                $('#form_participant').attr('data-id', id);
                $('#form_participant').attr('data-participant_round_id', participant_round_id);
                $('#form_participant').attr('data-currentstatus', output.data[0].active);
                $('#form_participant').attr('data-name', output.data[0].fname + ' ' + output.data[0].lname);
                $('#form_participant .field_container label.error').hide();
                $('#form_participant .field_container').removeClass('valid').removeClass('danger');
                $('#form_participant #fname').val(output.data[0].fname);
                $('#form_participant #lname').val(output.data[0].lname);
                $('#form_participant #email').val(output.data[0].email);
                $('#form_participant #mobile').val(output.data[0].mobile);
                $('#form_participant #mgr_fname').val(output.data[0].mgr_fname);
                $('#form_participant #mgr_lname').val(output.data[0].mgr_lname);
                $('#form_participant #mgr_email').val(output.data[0].mgr_email);
                $('#form_participant #activelabel').show();
                $('#form_participant #active').show();
                $('#form_participant #linked_framework').hide();

                $('#form_participant #gender').empty();
                var isSelected = false;

                if (output.data[0].gender == 'M') isSelected = true;
                $('#form_participant #gender').append($('<option>', {
                    value: 'M',
                    text: 'Male',
                    selected: isSelected
                }));
                var isSelected = false;

                if (output.data[0].gender == 'F') isSelected = true;
                $('#form_participant #gender').append($('<option>', {
                    value: 'F',
                    text: 'Female',
                    selected: isSelected
                }));
                var isSelected = false;

                if (output.data[0].gender == 'O') isSelected = true;
                $('#form_participant #gender').append($('<option>', {
                    value: 'O',
                    text: 'Other',
                    selected: isSelected
                }));

                $('#form_participant #round').empty();
                var dummyEmails = false;
                $.each(output.data[0].rounds, function (key, val) {
                    var isSelected = false;
                    if (val[0] == round_id) {
                        isSelected = true;
                        if (val[2] == 1) {
                            dummyEmails = true;
                        }
                    }
                    $('#form_participant #round').append($('<option>', {
                        value: val[0],
                        text: val[1],
                        selected: isSelected
                    }));
                });
                if (dummyEmails) {
                    //hide email field, make non-mandatory
                    $('#form_participant #email').removeClass('required');
                    $('#form_participant #email_row').hide();
                } else {
                    $('#form_participant #email').addClass('required');
                    $('#form_participant #email_row').show();
                }
                $('#form_participant #active').empty();
                $.each(output.data[0].statuses, function (key, val) {
                    var isSelected = false;
                    if (val == output.data[0].status) {
                        isSelected = true;
                    }
                    $('#form_participant #active').append($('<option>', {
                        value: key,
                        text: val,
                        selected: isSelected
                    }));
                });

                if (output.data[0].email == $('#email_marker').val()) {
                    $('#form_participant #email').removeClass('required');
                    $('#email').prop('disabled', true);
                    $('#disable_email').prop( "checked", true );

                } else {
                    $('#form_participant #email').addClass('required');
                    $('#email').prop('disabled', false);
                    $('#disable_email').prop( "checked", false );
                }

                $('#form_participant #reporting_groups').empty();

                var list = "";
                $.each(output.data[0].all_reporting_groups, function (key, val) {
                    list = list + '<label class="container">' + val['name'];
                    if ($.inArray(val['id'], output.data[0].reporting_groups_ids) !== -1) {
                        list = list + '<input type="checkbox" checked="checked" name="reportinggroupid[]" value="' + val['id'] + '">';
                    } else {
                        list = list + '<input type="checkbox" name="reportinggroupid[]" value="' + val['id'] + '">';
                    }
                    list = list + '<span class="checkmark"></span></label>';
                });
                $('#form_participant #reporting_groups').append(list);

                hide_loading_message();
                show_lightbox();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'danger');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'danger');
        });
    });

    // Edit participant submit form
    $(document).on('submit', '#form_participant.edit', function (e) {
        e.preventDefault();
        // Validate form
        var bContinue = true;
        var id = $('#form_participant').attr('data-id');
        var participant_round_id = $('#form_participant').attr('data-participant_round_id');
        var participant_name = $(this).data('name');
        var form_data = $('#form_participant').serialize();
        var csrf_token = $('meta[name="csrf-token"]').attr('content');
        var myReportingGroups = new Array();
        $("input[name='reportinggroupid[]'").each(function () {
            // $("input:checked").each(function () {
            //input[name='bla[]'
            myReportingGroups.push($(this).val());
        });
        var json_arr = JSON.stringify(myReportingGroups);
        if (form_participant.valid() == true) {
            if ($('#form_participant').attr('data-currentstatus') == "1" && $('#form_participant #active').val() == 0) {
                $.when(confirm_request("Are you sure you want to cancel '" + $('#form_participant').attr('data-name') + "?")).then(
                    function (result) {
                        if (result) {
                            hide_ipad_keyboard();
                            hide_lightbox();
                            show_loading_message();

                            var request = $.ajax({
                                url: '/' + subdir + '/participant_round_upload/edit_participant/f/' + framework_id,
                                cache: false,
                                data: form_data + '&' + $.param({'myReportingGroups': json_arr}) + '&' + $.param({'id': id}) + '&' + $.param({'participant_round_id': participant_round_id}) + '&' + $.param({'csrf_token': csrf_token}),
                                dataType: 'json',
                                // contentType:  'application/json; charset=utf-8',
                                type: 'POST'
                            });
                            request.done(function (output) {
                                if (output.result == 'success') {
                                    // Reload datable
                                    hide_loading_message();
                                    show_message("Participant edited successfully.", 'success');
                                    $('#' + table_participants_id).DataTable().ajax.reload(function () {
                                    }, false);
                                } else {
                                    hide_loading_message();
                                    show_message(output.message, 'danger');
                                }
                            });
                            request.fail(function (jqXHR, textStatus) {
                                hide_loading_message();
                                show_message('Edit request failed: ' + textStatus, 'danger');
                            });
                        }
                    }
                );
            } else {
                //do it without confirmation required (not cancelling)
                hide_ipad_keyboard();
                hide_lightbox();
                show_loading_message();

                var request = $.ajax({
                    // url:          '/' + dir + '/edit_participant/',
                    url: '/' + subdir + '/participant_round_upload/edit_participant/f/' + framework_id,
                    cache: false,
                    data: form_data + '&' + $.param({'myReportingGroups': json_arr}) + '&' + $.param({'id': id}) + '&' + $.param({'participant_round_id': participant_round_id}) + '&' + $.param({'csrf_token': csrf_token}),
                    dataType: 'json',
                    // contentType:  'application/json; charset=utf-8',
                    type: 'POST'
                });
                request.done(function (output) {
                    if (output.result == 'success') {
                        // Reload datable
                        hide_loading_message();
                        show_message("Participant '" + participant_name + "' edited successfully.", 'success');
                        $('#' + table_participants_id).DataTable().ajax.reload(function () {
                        }, false);
                    } else {
                        hide_loading_message();
                        show_message(output.message, 'danger');
                    }
                });
                request.fail(function (jqXHR, textStatus) {
                    hide_loading_message();
                    show_message('Edit request failed: ' + textStatus, 'danger');
                });
            }
        }
    });

    // Cancel participant (make round = -1)
    $(document).on('click', '.function_cancel a', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        var participant_name = $(this).data('name');
        var id = $(this).data('id');
        var participant_round_id = $(this).data('participant_round_id');
        var round_id = $(this).data('round_id');
        var csrf_token = $('meta[name="csrf-token"]').attr('content');

        $.when(confirm_request("Are you sure you want to cancel '" + participant_name + "'?")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/participant_round_upload/cancel_participant/f/' + framework_id,
                        cache: false,
                        dataType: 'json',
                        data: {
                            participant_round_id: participant_round_id,
                            name: participant_name,
                            round_id: round_id,
                            csrf_token: csrf_token
                        },
                        // contentType: 'application/json; charset=utf-8',
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            //hide_loading_message();
                            show_message("Participant '" + participant_name + "' cancelled successfully.", 'success');
                            $('#' + table_participants_id).DataTable().ajax.reload(function () {
                            }, false);
                        } else {
                            //hide_loading_message();
                            show_message('Cancel request failed: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Cancel request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });
// Fully delete participant (delete all tokens for participant and respondent, and delete participant and respondent round information)
    $(document).on('click', '.function_delete_participant a', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        var participant_name = $(this).data('name');
        var id = $(this).data('id');
        var participant_round_id = $(this).data('participant_round_id');
        var round_id = $(this).data('round_id');
        var csrf_token = $('meta[name="csrf-token"]').attr('content');

        $.when(confirm_request("Are you sure you want to delete '" + participant_name + "'? WARNING: this will remove ALL participant data and all linked respondent data.")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/participant_round_upload/delete_participant/f/' + framework_id,
                        cache: false,
                        dataType: 'json',
                        data: {
                            participant_round_id: participant_round_id,
                            name: participant_name,
                            round_id: round_id,
                            csrf_token: csrf_token
                        },
                        // contentType: 'application/json; charset=utf-8',
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            //hide_loading_message();
                            show_message("Participant deleted successfully.", 'success');
                            $('#' + table_participants_id).DataTable().ajax.reload(function () {
                            }, false);
                        } else {
                            //hide_loading_message();
                            show_message('Delete request failed: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Delete request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });

    // go to participant status
    $(document).on('click', '.function_status a', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var round_id = $(this).data('round_id');
        window.location = '/'+subdir+'/participant_round_status/f/'+framework_id+'/participant/' + id + '/round/' + round_id;

    });
    //tooltips for tables
    $('[data-toggle="tooltip"]').tooltip({});

    $('#linked_participants').change(function () {
        //get participant information from database, populate fields :

        var id = $('#linked_participants option:selected').val();
        var selected_framework_id = $('#parent_framework_id').val();
        if (id > 0) {
            var request = $.ajax({
                url: '/' + subdir + '/participant_round_display/get_participant/f/' + framework_id,
                cache: false,
                data: 'id=' + id + '&framework_id=' + selected_framework_id,
                dataType: 'json',
                contentType: 'application/json; charset=utf-8',
                type: 'get'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    $('#form_participant #fname').val(output.data[0].fname);
                    $('#form_participant #lname').val(output.data[0].lname);
                    $('#form_participant #email').val(output.data[0].email);
                    $('#form_participant #gender').val(output.data[0].gender);
                    $('#form_participant #mobile').val(output.data[0].mobile);

                    $('#form_participant #mgr_fname').val(output.data[0].mgr_fname);
                    $('#form_participant #mgr_lname').val(output.data[0].mgr_lname);
                    $('#form_participant #mgr_email').val(output.data[0].mgr_email);

                    $('#form_participant #reporting_groups').empty();

                    var list = "";
                    $.each(output.data[0].all_reporting_groups, function (key, val) {
                        list = list + '<label class="container">' + val['name'];
                        if ($.inArray(val['id'], output.data[0].reporting_groups_ids) !== -1) {
                            list = list + '<input type="checkbox" checked="checked" name="reportinggroupid[]" value="' + val['id'] + '">';
                        } else {
                            list = list + '<input type="checkbox" name="reportinggroupid[]" value="' + val['id'] + '">';
                        }
                        list = list + '<span class="checkmark"></span></label>';
                    });
                    $('#form_participant #reporting_groups').append(list);

                    //ft3 - manager


                } else {
                    show_message('Information request failed', 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                show_message('Information request failed: ' + textStatus, 'danger');
            });
        } else {
            $('#form_participant #fname').val("");
            $('#form_participant #lname').val("");
            $('#form_participant #email').val("");
            $('#form_participant #gender').val("");
            $('#form_participant #mobile').val("");

            $('#form_participant #mgr_fname').val("");
            $('#form_participant #mgr_lname').val("");
            $('#form_participant #mgr_email').val("");
        }
    });

    $('#round').change(function () {
        //get participant information from database, populate fields :
        set_emails();
    });

    function set_emails(){

        var id = $('#round option:selected').val();

        var request = $.ajax({
            url: '/' + subdir + '/round/get_round/f/' + framework_id,
            cache: false,
            data: 'id=' + id,
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                if (output.data[0]["dummy_emails"] == 1) {
                    //hide email field, make non-mandatory
                    $('#form_participant #email').removeClass('required');
                    $('#form_participant #email_row').hide();
                } else {
                    $('#form_participant #email').addClass('required');
                    $('#form_participant #email_row').show();
                }
            } else {
                show_message('Information request failed', 'danger');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            show_message('Information request failed: ' + textStatus, 'danger');
        });
    }


    $('#disable_email').change(function () {
        set_disable_email();
    });

    function set_disable_email(){
        if ($('#disable_email').is(':checked')){
            $('#form_participant #email').removeClass('required');
            $('#form_participant #email').val($('#email_marker').val());
            $('#email').prop('disabled', true);
        } else {
            $('#form_participant #email').addClass('required');
            $('#form_participant #email').val('');
            $('#email').prop('disabled', false);
        }
    }

    $('#drop').change(function () {
        $('#' + table_participants_id).DataTable().ajax.reload(null, true);
    });

    $('#openroundsonly').change(function () {
        $('#' + table_participants_id).DataTable().ajax.reload(null, true);
    });

    $('#showcancelled').change(function () {
        $('#' + table_participants_id).DataTable().ajax.reload(null, true);
    });

    $('#activeonlyno').click(function () {
        $('#' + table_participants_id).DataTable().ajax.reload(null, true);
    });
    $('#activeonlyyes').click(function () {
        $('#' + table_participants_id).DataTable().ajax.reload(null, true);
    });

    //hide search option for yes/no drop downs
    $('#showcancelled').select2({
        minimumResultsForSearch: -1
    });
    $('#openroundsonly').select2({
        minimumResultsForSearch: -1
    });


});
