$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    var dir = params[1] + '/' + params[2];

    /*
     * DATATABLE INITIALISATION
     */

    var table_respondents = $('#table_respondents').DataTable({
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/user_round/get_participant_respondents',
            "data": function (d) {
                d.activeonly = $('#activeonly option:selected').val();
                d.selectedframeworkid = $('#selectframework option:selected').val();
                d.type = 'participant';
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "name"},
            {"data": "email"},
            {"data": "relationship"},
            {"data": "approved"},
            {"data": "framework_name"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "order": [],
        "aaSorting": [],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        },
        "fnDrawCallback": function ( oSettings ) {
            $('#table_respondents').DataTable().rows(':not(.parent)').nodes().to$().find('td:first-child').trigger('click');
        }
    });

    setInterval(function () {
        $('#table_respondents').DataTable().ajax.reload(null, false);
    }, 120000);


    //focus loop for lightbox
    $("body").on('#form_respondent select2:close',function (e) {
        $('#rater_submit').focus();
    });
    $("#rater_submit").on('blur',function (e) {
        $('#fname').focus();
    });


    /*
     * ERROR HANDLING
     */


    $.fn.dataTable.ext.errMode = 'none';

    $('#table_respondents')
        .on('error.dt', function (e, settings, techNote, message) {
            // console.log( 'An error has been reported by DataTables: ', message );
            show_message("Table information could not refresh as there is a connection issue, you may have lost network connection or been logged out", 'danger');
            //redirect
            // window.location='index.php';
        })
        .DataTable();

    // On page load: form validation
    jQuery.validator.setDefaults({
        success: 'valid',
        rules: {
            email: {
                required: true,
                email: true
            }
        },
        errorPlacement: function (error, element) {
            error.insertBefore(element);
        },
        highlight: function (element) {
            $(element).parent('.field_container').removeClass('valid').addClass('error');
        },
        unhighlight: function (element) {
            $(element).parent('.field_container').addClass('valid').removeClass('error');
        }
    });
    var form_respondent = $('#form_respondent');
    form_respondent.validate();

    // Hide message
    function hide_message() {
        $('#message').html('').attr('class', '');
        $('#message_container').hide();
    }

    // Show loading message
    function show_loading_message() {
        $('#loading_container').show();
    }

    // Hide loading message
    function hide_loading_message() {
        $('#loading_container').hide();
    }

    // Show lightbox
    function show_lightbox() {
        if (window.innerWidth < 768){
            var yloc = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset) ;
            yloc = yloc - 40;
            $('.lightbox_container').css('top',yloc+'px');
        }
        $('.lightbox_container').show();
        $('.lightbox_bg').show();
        $('.lightbox_container').show();
    }

    // Hide lightbox
    function hide_lightbox() {
        $('.lightbox_bg').hide();
        $('.lightbox_container').hide();
    }

    // Lightbox background
    $(document).on('click', '.lightbox_bg', function () {
        hide_lightbox();
    });
    // Lightbox close button
    $(document).on('click', '.lightbox_close', function () {
        hide_lightbox();
    });
    // Escape keyboard key
    $(document).keyup(function (e) {
        if (e.keyCode == 27) {
            hide_lightbox();
        }
    });

    // Hide iPad keyboard
    function hide_ipad_keyboard() {
        document.activeElement.blur();
        $('input').blur();
    }

    // Add participant button
    $(document).on('click', '#add_respondent', function (e) {
        e.preventDefault();
        // Get round info.  should have passed in framework_id as data id
        //show_loading_message();
        var request = $.ajax({
            url: '/' + subdir + '/user_round/get_relationships',
            cache: false,
            data: 'frameworkname=' + $("#selectframework option:selected").text() + '&selectedframeworkid=' + $('#selectframework').val(),
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('.lightbox_content h2').text('Add Rater to ' + $("#selectframework option:selected").text());
                $('#form_respondent button').html('Add Rater  <i class="icon-arrow-right14 position-right"></i>');
                $('#form_respondent').attr('class', 'form add');
                //$('#form_respondent').attr('data-name', output.data[0].fname + ' ' + output.data[0].lname);
                $('#form_respondent .field_container label.error').hide();
                $('#form_respondent .field_container').removeClass('valid').removeClass('error');
                $('#form_respondent #fname').val('');
                $('#form_respondent #lname').val('');
                $('#form_respondent #email').val('');
                $('#form_respondent #mgr_fname').val('');
                $('#form_respondent #mgr_lname').val('');
                $('#form_respondent #mgr_email').val('');
                $('#form_respondent #activelabel').hide();
                $('#form_respondent #framework').hide();
                $('#form_respondent #framework').val();
                $('#form_respondent #relationship').empty();
                $.each(output.data[0].relationships, function (key, val) {
                    $('#form_respondent #relationship').append($('<option>', {
                        value: val["code"],
                        text: val["value"]
                    }));
                });

                hide_loading_message();
                show_lightbox();
                $('#form_respondent #fname').focus();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'warning');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'warning');
        });
    });


    // Add participant submit form
    $(document).on('submit', '#form_respondent.add', function (e) {
        e.preventDefault();
        // Validate form
        if (form_respondent.valid() == true) {
            // Send company information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var form_data = $('#form_respondent').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');
            var request = $.ajax({
                url: '/' + subdir + '/user_round/add_participant_respondent',
                cache: false,
                data: form_data+'&'+$.param({ 'selectedframeworkid': $("#selectframework option:selected").val() })+'&'+$.param({ 'relationship_name': $("#relationship option:selected").text() }) + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                // contentType: 'application/json; charset=utf-8',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    $('#table_respondents').DataTable().ajax.reload(function () {
                        hide_loading_message();
                        show_message("Rater added successfully.", 'success');
                    }, true);
                    // Reload respondent count
                    //loadRespondentInfo();

                } else {
                    hide_loading_message();
                    show_message(output.message, 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Add request failed: ' + textStatus, 'danger');
            });
        }
    });

    // Edit respondent button
    $(document).on('click', '.function_edit a', function (e) {
        e.preventDefault();
        // Get company information from database
        //show_loading_message();
        var id = $(this).data('id');
        var request = $.ajax({
            url: '/' + subdir + '/user_round/get_participant_respondent',
            cache: false,
            data: {id: id, selectedframeworkid: $("#selectframework option:selected").val()},
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('.lightbox_content h2').text('Edit Rater');
                $('#form_respondent button').html('Edit Rater  <i class="icon-arrow-right14 position-right"></i>');
                $('#form_respondent').attr('class', 'form edit');
                $('#form_respondent').attr('data-id', id);
                $('#form_respondent').attr('data-name', output.data[0].fname + ' ' + output.data[0].lname);
                $('#form_respondent .field_container label.error').hide();
                $('#form_respondent .field_container').removeClass('valid').removeClass('error');
                $('#form_respondent #fname').val(output.data[0].fname);
                $('#form_respondent #lname').val(output.data[0].lname);
                $('#form_respondent #email').val(output.data[0].email);
                $('#form_respondent #relationship').empty();
                $.each(output.data[0].relationships, function (key, val) {
                    var isSelected = false;
                    if (val["code"] == output.data[0].type) {
                        isSelected = true;
                    }
                    $('#form_respondent #relationship').append($('<option>', {
                        value: val["code"],
                        text: val["value"],
                        selected: isSelected
                    }));
                });

                hide_loading_message();
                show_lightbox();
            } else {
                hide_loading_message();
                show_message('Edit request failed', 'danger');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Add request failed: ' + textStatus, 'danger');
        });
    });

    // Edit respondent submit form
    $(document).on('submit', '#form_respondent.edit', function (e) {
        e.preventDefault();
        // Validate form
        if (form_respondent.valid() == true) {

            // Send company information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var id = $('#form_respondent').attr('data-id');
            var form_data = $('#form_respondent').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');
            var request = $.ajax({
                url: '/' + subdir + '/user_round/edit_participant_respondent',
                cache: false,
                data: form_data +'&'+$.param({ 'selectedframeworkid': $("#selectframework option:selected").val() })+'&'+$.param({ 'id': id })+'&'+$.param({ 'relationship_name': $("#relationship option:selected").text() }) + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                // contentType: 'application/json; charset=utf-8',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    $('#table_respondents').DataTable().ajax.reload(function () {
                        hide_loading_message();
                        show_message(output.message, 'success');
                    }, true);
                } else {
                    hide_loading_message();
                    show_message(output.message, 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Edit request failed: ' + textStatus, 'danger');
            });
        }
    });

    $('#activeonly').change(function () {
        $('#table_respondents').DataTable().ajax.reload(null, true);
    });

    $('#showrejected').change(function () {
        $('#table_respondents').DataTable().ajax.reload(null, true);
    });

    $('#selectframework').change(function () {
        $('#table_respondents').DataTable().ajax.reload(null, true);
        //loadRespondentInfo();
    });

    //hide search option for yes/no drop downs
    $('#selectframework').select2({
        minimumResultsForSearch: -1
    });
    $('#activeonly').select2({
        minimumResultsForSearch: -1
    });


    set_framework_variables();

    $('#selectframework').change(function () {
        //get participant information from database, populate fields :
        set_framework_variables();
    });

    function set_framework_variables(){

        var id = $('#selectframework option:selected').val();

        var request = $.ajax({
            url: '/' + subdir + '/user_round/get_round_by_framework/',
            cache: false,
            data: 'id=' + id,
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                if (output.data[0]["dummy_emails"] == 1) {
                    //hide email field, make non-mandatory
                    $('#form_respondent #email').removeClass('required');
                    $('#form_respondent #email_row').hide();
                } else {
                    $('#form_respondent #email').addClass('required');
                    $('#form_respondent #email_row').show();
                }

                if (output.data[0]["framework_type"] == 'FT3') {
                    //hide email field, make non-mandatory
                    $('#instructions').html('<i class="fa fa-info info-icon" aria-hidden="true" ></i> - Edit Rater Information (if not yet approved or rejected)' +
                        '<br />"Status" indicates whether your rater has been approved or rejected, or is waiting for review');
                } else {
                    $('#instructions').html('<i class="fa fa-info info-icon" aria-hidden="true" ></i> - Edit Rater Information');
                }
            } else {
                show_message('Information request failed', 'danger');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            show_message('Information request failed: ' + textStatus, 'danger');
        });
    }

//loadRespondentInfo();

//   function loadRespondentInfo(){
//     $.ajax({
//       url: './includes/' + thisdir + '/addrespondentdata.php?job=get_respondent_display&selected_framework_id='+$('#selectframework').val(),
//       data:'',
//       dataType: 'html',
//       type: "POST",
//       success:function(info){
//         $('#respondentinfo').html(info);
//       }
//     });
//   }


});
